//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

final class Recorder {
    // MARK: Internal Instance Properties
    
    private(set) var last: String?
    
    // MARK: Internal Initialization
    
    init(last: String? = nil) {
        self.last = last
    }
    
    // MARK: Internal Instance Interface
    
    func record(_ text: String) {
        last = text
    }
}
